import java.io.*;
import java.util.ArrayList;

public class Firma
{
    private ArrayList<Mitarbeiter> mitarbeiter;

    public Firma()
    {
        mitarbeiter = new ArrayList<>();
    }

    public void laden() throws MitarbeiterException
    {
        FileInputStream fis;
        ObjectInputStream ois;

        try
        {
            fis = new FileInputStream("/home/thomas/Desktop/Code_2024/Arbeiter/daten2.ser");
            ois = new ObjectInputStream(fis);

            mitarbeiter = (ArrayList<Mitarbeiter>) ois.readObject();

            ois.close();
            fis.close();
        }
        catch (FileNotFoundException e)
        {
            throw new MitarbeiterException("Fehler: File oder Pfad nicht gefunden!");
        }
        catch (IOException e)
        {
            throw new MitarbeiterException("Fehler: File nicht lesbar!");
        }
        catch (ClassNotFoundException e)
        {
            throw new MitarbeiterException("Fehler: Datenformat ist ungültig!");
        }
    }

    public void speichern() throws MitarbeiterException
    {
        FileOutputStream fos;
        ObjectOutputStream oos;

        try
        {
            fos = new FileOutputStream("/home/thomas/Desktop/Code_2024/Arbeiter/daten2.ser");
            oos = new ObjectOutputStream(fos);

            oos.writeObject(mitarbeiter);

            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e)
        {
            throw new MitarbeiterException("Fehler: Datei oder Pfad nicht gefunden!");
        }
        catch (IOException e)
        {
            throw new MitarbeiterException("Fehler: kann die Daten nicht schreiben!");
        }
    }

    public void exportMitarbeiter() throws MitarbeiterException
    {
        FileWriter fw;
        BufferedWriter bw;

        try
        {
            fw = new FileWriter("/home/thomas/Desktop/Code_2024/Arbeiter/daten2.txt");
            bw = new BufferedWriter(fw);

            for (Mitarbeiter m : mitarbeiter)
            {
                fw.write(m.toStringFile() + "\n");
            }

            fw.close();
            bw.close();
        }
        catch (IOException e)
        {
            throw new MitarbeiterException("Fehler: kann die Daten nicht schreiben!");
        }
    }

    public void importMitarbeiter() throws MitarbeiterException
    {
        Mitarbeiter m;
        String zeile;
        FileReader fr;
        BufferedReader br;

        //"C:\\Users\\Username\\Desktop\\testFile.txt"
        try
        {
            fr = new FileReader("/home/thomas/Desktop/Code_2024/Arbeiter/daten.txt");
            br = new BufferedReader(fr);
            zeile = br.readLine();
            while (zeile != null)
            {
                if (zeile.charAt(0) == 'R')
                {
                    m = new Arbeiter(zeile);
                    aufnehmen(m);
                }
                if (zeile.charAt(0) == 'N')
                {
                    m = new Angestellter(zeile);
                    aufnehmen(m);
                }

                zeile = br.readLine();
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e)
        {
            throw new MitarbeiterException("Fehler: Datei nicht gefunden!");
        }
        catch (IOException e)
        {
            throw new MitarbeiterException("Fehler: Datei kann nicht gelesen werden!");
        }
        catch (StringIndexOutOfBoundsException e)
        {
            throw new MitarbeiterException("Fehler: Dateiformat ungültig!");
        }
    }

    public void aufnehmen(Mitarbeiter m) throws MitarbeiterException
    {
        if (m == null)
            throw new MitarbeiterException("Fehler: kein Mitarbeiter!");
        mitarbeiter.add(m);
    }

    public String toString()
    {
        String erg;

        erg = "";
        for (Mitarbeiter m : mitarbeiter)
        {
            erg += m.toString() + "\n";
        }
        return erg;
    }
}
