import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class TestMitarbeiter
{
    @Test
    public void testZerlegungAngestellter()
    {
        String zeile;
        Angestellter a;

        try
        {
            zeile = "N;Gudrun;44;7;100;2900";
            a = new Angestellter(zeile);
            System.out.println(a);
        } catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testZerlegungArbeiter()
    {
        String zeile;
        Arbeiter a;

        try
        {
            zeile = "R;Susi;49;9;30;57.0";
            a = new Arbeiter(zeile);
            System.out.println(a);
        } catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testZerlegungUngultigesAlter()
    {
        String zeile;
        Arbeiter a;

        try
        {
            zeile = "R;Susi;21;9;30;57.0";
            a = new Arbeiter(zeile);
            System.out.println(a);
        } catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
        }
    }

    @Test
    public void testZerlegungKeinAlter()
    {
        String zeile;
        Arbeiter a;

        try
        {
            zeile = "R;Susi;;9;30;57.0";
            a = new Arbeiter(zeile);
            System.out.println(a);
        } catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
        }
    }
    /*
    @Test
    public void testSetAlterArbeiter()
    {
        Arbeiter max, fritz, franz;

        max   = new Arbeiter("Max",   21, 5, 10, 33); //Fehler
        fritz = new Arbeiter("Fritz", 61, 5, 10, 33); //Fehler
        franz = new Arbeiter("Franz", 26, 5, 10, 33);
        assertEquals(25, max.getAlter());
        assertEquals(25, fritz.getAlter());
        assertEquals(26, franz.getAlter());
    }

    @Test
    public void testSetAlterAngestellter()
    {
        Angestellter max, fritz, franz;

        max   = new Angestellter("Max",   15, 1,  100, 1800); //Fehler
        fritz = new Angestellter("Fritz", 66, 25, 50,  2800); //Fehler
        franz = new Angestellter("Franz", 26, 5,  100, 3300);
        assertEquals(25, max.getAlter());
        assertEquals(25, fritz.getAlter());
        assertEquals(26, franz.getAlter());
    }

    @Test
    public void testToStringArbeiter()
    {
        Arbeiter max;

        max = new Arbeiter("Max", 26, 5, 10, 33);
        System.out.println(max);
    }

    @Test
    public void testToStringAngestellter()
    {
        Angestellter susi;

        susi = new Angestellter("Susi", 33, 2, 50, 2000);
        System.out.println(susi);
    }

    @Test
    public void testGetGeldMonat()
    {
        Angestellter susi;
        Arbeiter max;

        susi  = new Angestellter("Susi", 33, 2, 50, 2000);
        max   = new Arbeiter("Max",      24, 5, 10, 33); //Fehler
        assertEquals(2000, susi.getGeldMonat(), 0.1);
        assertEquals(1419, max.getGeldMonat(), 0.1);
    }

    @Test
    public void testGetGeldMonat40Stunden()
    {
        Angestellter susi;
        Arbeiter max;

        susi  = new Angestellter("Susi", 33, 2, 40, 2000);
        max   = new Arbeiter("Max",      24, 5, 10, 33); //Fehler
        assertEquals(5000, susi.getGeldMonat40Stunden(), 0.1);
        assertEquals(5676, max.getGeldMonat40Stunden(), 0.1);
    }
    */
    @Test
    public void testSetAlter()
    {
        Arbeiter max, susi, alex;

        try
        {
            max = new Arbeiter("Max Mayer", 14, 5, 20, 25);
            System.out.println(max);
            assertEquals(1,2);
        }
        catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
            // Fehler: Der Arbeiter ist zu jung!
            assertEquals("Fehler: Der Arbeiter ist zu jung!", e.getMessage());
        }

        try
        {
            susi = new Arbeiter("Susi Berger", 25, 5,  20, 30);
            System.out.println(susi);
            assertEquals(1,1);
        }
        catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
            assertEquals(1,2);
        }

        try
        {
            alex = new Arbeiter("Alex Neumayr", 70,   50, 10, 40);
            assertEquals(1,2);
        }
        catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
            // Fehler: Der Arbeiter ist zu jung!
            assertEquals("Fehler: Der Arbeiter ist zu alt!", e.getMessage());
        }
    }

    @Test
    public void testGetInitialen()
    {
        Arbeiter max, susi, alex;

        try
        {
            max = new Arbeiter("Max Mayer", 26, 5, 20, 25);
            System.out.println(max);
            System.out.println(max.getInitialen());
            assertEquals("MMay", max.getInitialen());
        }
        catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
            assertEquals(1,2);
        }

        try
        {
            susi = new Arbeiter("Susi", 25, 5,  20, 30);
            System.out.println(susi);
            System.out.println(susi.getInitialen());
            assertEquals(1,2);
        }
        catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
            assertEquals("Fehler: es gibt keinen Nachnamen!", e.getMessage());
        }

        try
        {
            alex = new Arbeiter("Alex N", 26,   50, 10, 40);
            System.out.println(alex);
            System.out.println(alex.getInitialen());
            assertEquals(1,2);
        }
        catch (MitarbeiterException e)
        {
            System.out.println(e.getMessage());
            assertEquals("Fehler: der Nachname ist zu kurz!", e.getMessage());
        }
    }

    /*
    @Test
    public void testToStringMitarbeiter()
    {
        Mitarbeiter thomas;

        thomas = new Mitarbeiter("Thomas", 51, 25);
        System.out.println(thomas);
    }
    */
}