public abstract class Mitarbeiter
{
    private   String name;
    protected int    alter;
    private   int    dienstjahre;

    public Mitarbeiter(String zeile) throws MitarbeiterException
    {
        String[] teile;
        teile = zeile.split(";");

        try
        {
            setName(teile[1]);
            setAlter(Integer.parseInt(teile[2]));
            setDienstjahre(Integer.parseInt(teile[3]));
        }
        catch (NumberFormatException e)
        {
            throw new MitarbeiterException("Fehler: keine Zahl - ungültiges Format");
        }
    }

    public Mitarbeiter(String name, int alter, int dienstjahre) throws MitarbeiterException
    {
        setName(name);
        setAlter(alter);
        setDienstjahre(dienstjahre);
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public int getAlter()
    {
        return alter;
    }

    public abstract void setAlter(int alter) throws MitarbeiterException;

    public abstract double getGeldMonat();

    public abstract double getGeldMonat40Stunden();

    /*
    public String getInitialen() throws MitarbeiterException
    {
        String erg;
        int pos;

        try
        {
            if (name.contains(" "))
            {
                pos = name.indexOf(" ") + 1;
                erg = name.substring(0, 1);
                erg += name.substring(pos, pos + 3);

                return erg;
            }
            else
            {
                throw new MitarbeiterException("Fehler: es gibt keinen Nachnamen!");
            }
        }
        catch (IndexOutOfBoundsException e)
        {
            throw new MitarbeiterException("Fehler: der Nachname ist zu kurz!");
        }
    }
    */

    public String getInitialen() throws MitarbeiterException
    {
        String erg;
        int pos;

        if (name.contains(" ") == false)
            throw new MitarbeiterException("Fehler: es gibt keinen Nachnamen!");

        try
        {
            pos = name.indexOf(" ") + 1;
            erg = name.substring(0, 1);
            erg += name.substring(pos, pos + 3);
            return erg;
        }
        catch (IndexOutOfBoundsException e)
        {
            throw new MitarbeiterException("Fehler: der Nachname ist zu kurz!");
        }
    }



    public int getDienstjahre()
    {
        return dienstjahre;
    }

    public void setDienstjahre(int dienstjahre)
    {
        this.dienstjahre = dienstjahre;
    }

    @Override
    public String toString()
    {
        return name + " " + alter + " Jahre " + dienstjahre + " Dienstjahre";
    }
}
