import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class Firma
{
    private ArrayList<Mitarbeiter> mitarbeiter;

    public Firma()
    {
        mitarbeiter = new ArrayList<>();
    }

    public void importMitarbeiter() throws MitarbeiterException
    {
        Mitarbeiter m;
        String zeile;
        FileReader fr;
        BufferedReader br;

        //"C:\\Users\\Username\\Desktop\\testFile.txt"
        try
        {
            fr = new FileReader("/home/thomas/Desktop/Code_2024/Arbeiter/daten.txt");
            br = new BufferedReader(fr);
            zeile = br.readLine();
            while (zeile != null)
            {
                if (zeile.charAt(0) == 'R')
                {
                    m = new Arbeiter(zeile);
                    aufnehmen(m);
                }
                if (zeile.charAt(0) == 'N')
                {
                    m = new Angestellter(zeile);
                    aufnehmen(m);
                }

                zeile = br.readLine();
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e)
        {
            throw new MitarbeiterException("Fehler: Datei nicht gefunden!");
        }
        catch (IOException e)
        {
            throw new MitarbeiterException("Fehler: Datei kann nicht gelesen werden!");
        }
        catch (StringIndexOutOfBoundsException e)
        {
            throw new MitarbeiterException("Fehler: Dateiformat ungültig!");
        }
    }

    public void aufnehmen(Mitarbeiter m) throws MitarbeiterException
    {
        if (m == null)
            throw new MitarbeiterException("Fehler: kein Mitarbeiter!");
        mitarbeiter.add(m);
    }

    public String toString()
    {
        String erg;

        erg = "";
        for (Mitarbeiter m : mitarbeiter)
        {
            erg += m.toString() + "\n";
        }
        return erg;
    }
}
