public class Arbeiter extends Mitarbeiter
{
    private int    anzahlStundenWoche;
    private double stundenLohn;

    public Arbeiter(String name, int alter, int dienstjahre, int anzahlStundenWoche, double stundenLohn) throws MitarbeiterException
    {
        super(name, alter, dienstjahre);
        setAnzahlStundenWoche(anzahlStundenWoche);
        setStundenLohn(stundenLohn);
    }

    public Arbeiter(String zeile) throws MitarbeiterException
    {
        super(zeile);

        String[] teile;
        teile = zeile.split(";");

        try
        {
            setAnzahlStundenWoche(Integer.parseInt(teile[4]));
            setStundenLohn(Double.parseDouble(teile[5]));
        }
        catch (NumberFormatException e)
        {
            throw new MitarbeiterException("Fehler: keine Zahl - ungültiges Format");
        }
    }
    /*
    @Override
    public void setAlter(int alter) throws MitarbeiterException
    {
        if (alter >= 22 && alter <= 60)
        {
            this.alter = alter;
        }
        else
        {
            if (alter < 22)
            {
                throw new MitarbeiterException("Fehler: Der Arbeiter ist zu jung!");
            }
            else
            {
                throw new MitarbeiterException("Fehler: Der Arbeiter ist zu alt!");
            }
        }
    }*/

    @Override
    public void setAlter(int alter) throws MitarbeiterException
    {
        if (alter < 22)
            throw new MitarbeiterException("Fehler: Der Arbeiter ist zu jung!");
        if (alter > 60)
            throw new MitarbeiterException("Fehler: Der Arbeiter ist zu alt!");

        this.alter = alter;
    }


    @Override
    public double getGeldMonat()
    {
        return 4.3 * (anzahlStundenWoche * stundenLohn);
    }

    @Override
    public double getGeldMonat40Stunden()
    {
        return 4.3 * (40 * stundenLohn);
    }

    public int getAnzahlStundenWoche()
    {
        return anzahlStundenWoche;
    }

    public void setAnzahlStundenWoche(int anzahlStundenWoche)
    {
        this.anzahlStundenWoche = anzahlStundenWoche;
    }

    public double getStundenLohn()
    {
        return stundenLohn;
    }

    public void setStundenLohn(double stundenLohn)
    {
        this.stundenLohn = stundenLohn;
    }

    @Override
    public String toString()
    {
        String erg;

        erg = "Arbeiter " + super.toString();
        erg = erg + " " + anzahlStundenWoche + " Stunden " + stundenLohn + " EUR/Stunde";
        return erg;
    }
}
