public class Angestellter extends Mitarbeiter
{
    private int    prozentVollbeschaftigt;
    private double gehaltMonat;

    public Angestellter(String zeile) throws MitarbeiterException
    {
        super(zeile);

        String[] teile;
        teile = zeile.split(";");

        try
        {
            setProzentVollbeschaftigt(Integer.parseInt(teile[4]));
            setGehaltMonat(Double.parseDouble(teile[5]));
        }
        catch (NumberFormatException e)
        {
            throw new MitarbeiterException("Fehler: keine Zahl - ungültiges Format");
        }
    }


    public Angestellter(String name, int alter, int dienstjahre, int prozentVollbeschaftigt, double gehaltMonat) throws MitarbeiterException
    {
        super(name, alter, dienstjahre);
        setProzentVollbeschaftigt(prozentVollbeschaftigt);
        setGehaltMonat(gehaltMonat);
    }

    @Override
    public void setAlter(int alter)
    {
        if ((alter >= 16) && (alter <= 65))
        {
            this.alter = alter;
        }
        else
        {
            System.out.println("Fehler: ungültiges Alter!");
            this.alter = 25;
        }
    }

    @Override
    public double getGeldMonat()
    {
        return gehaltMonat;
    }

    @Override
    public double getGeldMonat40Stunden()
    {
        return (gehaltMonat / prozentVollbeschaftigt) * 100;
    }


    public int getProzentVollbeschaftigt()
    {
        return prozentVollbeschaftigt;
    }

    public void setProzentVollbeschaftigt(int prozentVollbeschaftigt)
    {
        this.prozentVollbeschaftigt = prozentVollbeschaftigt;
    }

    public double getGehaltMonat()
    {
        return gehaltMonat;
    }

    public void setGehaltMonat(double gehaltMonat)
    {
        this.gehaltMonat = gehaltMonat;
    }

    @Override
    public String toString()
    {
        String erg;

        erg = "Angestellter " + super.toString();
        erg = erg + " " + prozentVollbeschaftigt + "% Vollbesch " + gehaltMonat + " EUR/Monat";
        return erg;
    }
}
