public class PersonenZug extends Zug
{
    private int anzahlPersonen;

    public PersonenZug(String bahnhof, double km, boolean zulassung, int anzahlWagon, int anzahlPersonen) throws ZugException
    {
        super(bahnhof, km, zulassung, anzahlWagon);
        setAnzahlPersonen(anzahlPersonen);
    }

    public int getAnzahlPersonen()
    {
        return anzahlPersonen;
    }

    public void setAnzahlPersonen(int anzahlPersonen)
    {
        this.anzahlPersonen = anzahlPersonen;
    }

    @Override
    public void setKm(double km) throws ZugException
    {
        if (km < 0)
            throw new ZugException("Fehler: km muss mind. 0 sein!");
        if (km > 50000)
            throw new ZugException("Fehler: Personenzuge dürfen max. 50000 km haben!");

        this.km = km;
    }

    @Override
    public void setAnzahlWagon(int anzahlWagon) throws ZugException
    {
        if (anzahlWagon < 1)
            throw new ZugException("Fehler: mind. 1 Wagon bei Personenzügen!");
        if (anzahlWagon > 5)
            throw new ZugException("Fehler: max. 5 Wagon bei Personenzügen!");

        this.anzahlWagon = anzahlWagon;
    }

    @Override
    public String toString()
    {
        return "Personen Zug: " + super.toString() + "   " + anzahlPersonen + " Fahrgäste";
    }
}
