public abstract class Product
{
    private   String productType;
    protected double price;         // ohne Steuer
    protected int    numberStock;

    public Product(String productType, double price) throws ProductException
    {
        setProductType (productType);
        setPrice (price);
    }

    public String getProductType()
    {
        return productType;
    }

    public void setProductType(String productType)
    {
        this.productType = productType;
    }

    public double getPrice()
    {
        return price;
    }

    public abstract void setPrice(double price) throws ProductException;

    public int getNumberStock()
    {
        return numberStock;
    }

    public void setNumberStock(int numberStock) throws ProductException
    {
        if (numberStock < 0)
            throw new ProductException("Fehler: ungültiger Lagerbestand - mind 0 Stück!");
        if (numberStock > 50)
            throw new ProductException("Fehler: ungültiger Lagerbestand - max 50 Stück!");

        this.numberStock = numberStock;
    }

    public double getStockValue()
    {
        return (numberStock*price) * 1.2;
    }

    @Override
    public String toString()
    {
        return productType + "   " + price + " EUR - " + numberStock + " Stück Lager";
    }
}
