public class Drink extends Product
{
    private boolean alcohol;

    public Drink(String productType, double price, int numberStock, boolean alcohol) throws ProductException
    {
        super(productType, price);
        setAlcohol (alcohol);
        setNumberStock(numberStock);
    }

    public boolean isAlcohol()
    {
        return alcohol;
    }

    public void setAlcohol(boolean alcohol)
    {
        this.alcohol = alcohol;
    }

    @Override
    public void setPrice(double price) throws ProductException
    {
        if (price < 3)
            throw new ProductException("Fehler: ungültiger Preis - mind. 3 EUR!");
        if (price > 10)
            throw new ProductException("Fehler: ungültiger Preis - max. 10 EUR!");

        this.price = price;
    }

    @Override
    public void setNumberStock(int numberStock) throws ProductException
    {
        if (numberStock < 0)
            throw new ProductException("Fehler: ungültiger Lagerbestand - mind. 0 Stück!");
        if ((alcohol == true)  && (numberStock > 10))
            throw new ProductException("Fehler: ungültiger Lagerbestand bei alk. Gertränken - max. 10 Stück!");
        if ((alcohol == false) && (numberStock > 50))
            throw new ProductException("Fehler: ungültiger Lagerbestand bei antialk. Gertränken - max. 50 Stück!");

        this.numberStock = numberStock;
    }

    @Override
    public double getStockValue()
    {
        if (alcohol)
            return (numberStock*price) * 1.4;
        else
            return (numberStock*price) * 1.2;
    }

    @Override
    public String toString()
    {
        if (alcohol)
            return super.toString() + " Alcohol";
        else
            return super.toString() + " no Alcohol";
    }
}
