import java.util.ArrayList;
import java.util.Iterator;

public class Handler {
    private ArrayList<Produkt> produkte;

    public Handler() {
        produkte = new ArrayList<>();
    }

    public void aufnehmen(Produkt produkt) {
        if (produkt == null)
            throw new RuntimeException("Fehler: kein Produkt");
        if (produkte.size() >= 8)
            throw new RuntimeException("Fehler: schon 8 Produkte");
        if (produkte.contains(produkt))
            throw new RuntimeException("Fehler: Produkt schon vorhanden");

        produkte.add(produkt);
    }

    public Produkt billigstesProdukt(String hersteller) {
        Produkt prd;
        double min;

        if (hersteller == null)
            throw new RuntimeException("Fehler: kein Hersteller!");

        min = 9999999;
        prd = null;
        for (Produkt p : produkte) {
            if ((p.getPreis() < min) && (p.getHersteller().equals(hersteller))) {
                min = p.getPreis();
                prd = p;
            }
        }
        return prd;
    }

    public int loscheProdukt(double uberPreis) {
        Iterator<Produkt> it;
        Produkt p;
        int anz = 0;

        it = produkte.iterator();
        while (it.hasNext()) {
            p = it.next();
            if (p.getPreis() > uberPreis) {
                it.remove();
                anz++;
            }
        }
        return anz;
    }

    public ArrayList<Produkt> getProdukte() {
        return produkte;
    }

    @Override
    public String toString() {
        return produkte.toString();
    }
}
