import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class BTestAufnehmen {
    @Test
    public void testInstanz() {
        Handler markt;
        markt = new Handler();
        assertNotEquals(null, markt.getProdukte());
    }

    @Test
    public void testAufnehmenNULL() {
        try {
            Handler markt;
            markt = new Handler();
            markt.aufnehmen(null);
            assertEquals(0, markt.getProdukte().size());
        }
        catch (Exception e) {
            assertEquals(1,1);
        }
    }

    @Test
    public void testAufnehmen9() {
        Handler markt;
        markt = new Handler();
        try {
            Produkt a, b, c, d, e, f, g, h, i;
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   1999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("MSI",    1299.0);
            h = new Produkt("Lenovo", 899.9);
            i = new Produkt("Dell",   749.0);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            markt.aufnehmen(g);
            markt.aufnehmen(h);
            markt.aufnehmen(i);
            assertEquals(1, 0);
        }
        catch (Exception e) {
            assertEquals(8, markt.getProdukte().size());
        }
    }

    @Test
    public void testAufnehmenDoppelt() {
        Handler markt;
        markt = new Handler();
        try {
            Produkt a, b, c, d, e, f, g, h, i;
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   1999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("MSI",    1299.0);
            h = new Produkt("Lenovo", 899.9);
            i = new Produkt("Dell",   749.0);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(c);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            markt.aufnehmen(g);
            markt.aufnehmen(h);
            assertEquals(1, 0);
        }
        catch (Exception e) {
            assertEquals(4, markt.getProdukte().size());
        }
    }

    @Test
    public void testAufnehmenOK() {
        try {
            Handler markt;
            Produkt a, b, c, d, e, f, g, h, i, j, k;
            markt = new Handler();
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   1999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("MSI",    1299.0);
            h = new Produkt("Lenovo", 899.9);
            i = new Produkt("Dell",   749.0);
            j = new Produkt("HP",     659.9);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            assertEquals(a, markt.getProdukte().get(0));
            assertEquals(b, markt.getProdukte().get(1));
            assertEquals(c, markt.getProdukte().get(2));
            assertEquals(d, markt.getProdukte().get(3));
            assertEquals(e, markt.getProdukte().get(4));
            assertEquals(f, markt.getProdukte().get(5));
            assertEquals(6, markt.getProdukte().size());
        }
        catch (Exception e) {
            assertEquals(1,0);
        }
    }
}