public abstract class Produkt
{
	private String hersteller;
	private double preis;
	
	public Produkt(String hersteller, double preis)
	{
		setHersteller(hersteller);
		setPreis(preis);
	}
	
	public abstact void setPreis(double preis);
	
	public String toString()
	{
		return hersteller + " - " + preis + " Euro";
	}
	
public class Fernseher extends Produkt
{
	private int diagonaleZoll;
	
	public Fernseher(String hersteller, int diagonaleZoll, double preis)
	{
		super(hersteller, preis);
		setDiagonaleZoll(diagonaleZoll);
	}
	
	@Override
	public void setPreis(double preis)
	{
		// Fernseher zwischen 100 und 1200 Euro
		if ((preis >= 100) && (preis <= 1200))
		{
			this.preis = preis;
		}
		else
		{
			System.out.println("Fehler: ungültiger Preis");
			this.preis = 150;
		}
	}
	
	@Override
	public String toString()
	{
		// Fernseher: LG - 199.0 Euro - 65 Zoll
		"Fernseher: " + super.toString() + " - " + diagonaleZoll + " Zoll";
	}