import java.util.ArrayList;
import java.util.Iterator;

public class Handler {
    private ArrayList<Fahrzeug> fahrzeuge;

    public Handler() {
        fahrzeuge = new ArrayList<>(10);
    }

    public void hinzufugen(Fahrzeug neu) throws FahrzeugException {
        hinzufugen(fahrzeuge.size(), neu);
    }

    public void hinzufugen(int pos, Fahrzeug neu) throws FahrzeugException {
        if (neu == null)
            throw new FahrzeugException("Fehler: kein Fahrzeug!");
        if ((pos < 0) || (pos > fahrzeuge.size()))
            throw new FahrzeugException("Fehler: ungültige Position!");
        if (fahrzeuge.contains(neu))
            throw new FahrzeugException("Fehler: Fahrzeug schon vorhanden!");

        fahrzeuge.add(pos, neu);
    }


    /*
    public void hinzufugen(int pos, Fahrzeug neu) {
        if (neu != null) {
            if ((pos >= 0) && (pos <= fahrzeuge.size())) {
                if (fahrzeuge.contains(neu) == false) {
                    fahrzeuge.add(pos, neu);
                }
                else {
                    System.out.println("Fehler: Fahrzeug schon vorhanden!");
                }
            }
            else {
                System.out.println("Fehler: ungültige Position!");
            }
        }
        else {
            System.out.println("Fehler: kein Fahrzeug!");
        }
    }
    */

    public double avgPs() throws FahrzeugException {
        if (fahrzeuge.size() <= 0)
            throw new FahrzeugException("Fehler: keine Fahrzeuge vorhanden!");

        int summe = 0;
        for (Fahrzeug f : fahrzeuge) {
            summe += f.getPs();
        }
        return ((double) summe) / fahrzeuge.size();
    }

    public Fahrzeug maxPs() {
        int maxPs;
        Fahrzeug maxFahrzeug;

        maxPs = -9999;
        maxFahrzeug = null;
        for (Fahrzeug f : fahrzeuge) {
            if (f.getPs() > maxPs) {
                maxPs = f.getPs();
                maxFahrzeug = f;
            }
        }
        return maxFahrzeug;
    }

    public void losche(String hersteller) {
        Fahrzeug f;
        Iterator<Fahrzeug> it;

        it = fahrzeuge.iterator();
        while (it.hasNext()) {
            f = it.next();
            if (f.getHersteller().equals(hersteller)) {
                it.remove();
            }
        }
    }

    public Fahrzeug getFahrzeug(int pos) throws FahrzeugException {
        if ((pos < 0) || (pos >= fahrzeuge.size()))
            throw new FahrzeugException("Fehler: ungültige Position!");

        return fahrzeuge.get(pos);
    }

    public boolean contains(Fahrzeug f) {
        return fahrzeuge.contains(f);
    }

    @Override
    public String toString() {
        String erg;

        erg = "";
        for ( Fahrzeug f : fahrzeuge ) {
            erg = erg + f.toString() + "\n";
        }
        return erg;
    }
}
