import java.util.ArrayList;
import java.util.Iterator;

public class Handler {
    private ArrayList<Fahrzeug> fahrzeuge;

    public Handler() {
        fahrzeuge = new ArrayList<>(10);
    }

    public void hinzufugen(Fahrzeug neu) {
        hinzufugen(fahrzeuge.size(), neu);
    }

    public void hinzufugen(int pos, Fahrzeug neu) {
        if (neu != null) {
            if ((pos >= 0) && (pos <= fahrzeuge.size())) {
                if (fahrzeuge.contains(neu) == false) {
                    fahrzeuge.add(pos, neu);
                }
                else {
                    System.out.println("Fehler: Fahrzeug schon vorhanden!");
                }
            }
            else {
                System.out.println("Fehler: ungültige Position!");
            }
        }
        else {
            System.out.println("Fehler: kein Fahrzeug!");
        }
    }

    public double avgPs() {
        int summe = 0;

        for (Fahrzeug f : fahrzeuge) {
            summe += f.getPs();
        }
        if (fahrzeuge.size() > 0)
            return ((double) summe) / fahrzeuge.size();
        else {
            System.out.println("Fehler: keine Fahrzeuge vorhanden!");
            return -999;
        }
    }

    public Fahrzeug maxPs() {
        int maxPs;
        Fahrzeug maxFahrzeug;

        maxPs = -9999;
        maxFahrzeug = null;
        for (Fahrzeug f : fahrzeuge) {
            if (f.getPs() > maxPs) {
                maxPs = f.getPs();
                maxFahrzeug = f;
            }
        }
        return maxFahrzeug;
    }

    public void losche(String hersteller) {
        Fahrzeug f;
        Iterator<Fahrzeug> it;

        it = fahrzeuge.iterator();
        while (it.hasNext()) {
            f = it.next();
            if (f.getHersteller().equals(hersteller)) {
                it.remove();
            }
        }
    }

    public Fahrzeug getFahrzeug(int pos) {
        if ((pos >= 0) && (pos < fahrzeuge.size()))
            return fahrzeuge.get(pos);
        else {
            System.out.println("Fehler: ungültige Position!");
            return null;
        }
    }

    public boolean contains(Fahrzeug f) {
        return fahrzeuge.contains(f);
    }

    @Override
    public String toString() {
        String erg;

        erg = "";
        for ( Fahrzeug f : fahrzeuge ) {
            erg = erg + f.toString() + "\n";
        }
        return erg;
    }
}
