import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class CompanyTest
{
    @Test
    public void testHire2()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 25, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        c.hire(max);
        c.hire(susi);
        System.out.println(c);
        worker = c.getWorker();
        assertEquals(max, worker[0]);
        assertEquals(susi, worker[1]);
        assertEquals(null, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(2, c.getNumber());
    }

    @Test
    public void testHireMax2()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 25, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        c.hire(max);
        c.hire(susi);
        c.hire(max);
        System.out.println(c);
        worker = c.getWorker();
        assertEquals(max, worker[0]);
        assertEquals(susi, worker[1]);
        assertEquals(max, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(3, c.getNumber());
    }


    @Test
    public void testHire5()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 25, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        c.hire(max);
        c.hire(susi);
        c.hire(andrea);
        c.hire(werner);
        c.hire(karl);                       // Error
        System.out.println(c);
        worker = c.getWorker();
        assertEquals(max, worker[0]);
        assertEquals(susi, worker[1]);
        assertEquals(andrea, worker[2]);
        assertEquals(werner, worker[3]);
        assertEquals(4, c.getNumber());
    }

    @Test
    public void testNumberWorkerMore20()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 18, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        assertEquals(0, c.numberWorkerMore20());
        c.hire(max);
        assertEquals(1, c.numberWorkerMore20());
        c.hire(susi);
        assertEquals(2, c.numberWorkerMore20());
        c.hire(andrea);
        assertEquals(2, c.numberWorkerMore20());
        c.hire(werner);
        assertEquals(2, c.numberWorkerMore20());
    }

    @Test
    public void testMaxEarn()
    {
        Company c;
        Worker max, susi, andrea, werner;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 18, 40);
        werner = new Worker("Werner", 39, 47);

        assertEquals(null,c.maxEarn());

        c.hire(max);
        assertEquals(max,c.maxEarn());

        c.hire(susi);
        assertEquals(susi,c.maxEarn());

        c.hire(andrea);
        assertEquals(susi,c.maxEarn());

        c.hire(werner);
        assertEquals(werner,c.maxEarn());
    }

    @Test
    public void testRemove()
    {
        Company c;
        Worker max, susi, andrea, werner, alex;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 18, 40);
        werner = new Worker("Werner", 39, 47);
        alex   = new Worker("Alex",   15, 32);
        worker = c.getWorker();

        c.remove(null);                             //Error
        assertEquals(null, worker[0]);
        assertEquals(null, worker[1]);
        assertEquals(null, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(0, c.getNumber());

        c.hire(max);
        c.hire(susi);
        c.hire(andrea);
        c.hire(werner);

        c.remove(alex);                             //Error
        assertEquals(max,    worker[0]);
        assertEquals(susi,   worker[1]);
        assertEquals(andrea, worker[2]);
        assertEquals(werner, worker[3]);
        assertEquals(4, c.getNumber());

        c.remove(susi);
        assertEquals(max,    worker[0]);
        assertEquals(andrea, worker[1]);
        assertEquals(werner, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(3, c.getNumber());

        c.remove(werner);
        assertEquals(max,    worker[0]);
        assertEquals(andrea, worker[1]);
        assertEquals(null, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(2, c.getNumber());
    }

    @Test
    public void testSortSelectionHour()
    {
        Company c;
        Worker max, susi, andrea, werner;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 18, 40);
        werner = new Worker("Werner", 39, 47);
        worker = c.getWorker();

        c.sortSelectionHour();
        assertEquals(null, worker[0]);
        assertEquals(null, worker[1]);
        assertEquals(null, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(0, c.getNumber());

        c.hire(max);
        c.hire(susi);
        c.hire(andrea);
        c.hire(werner);

        c.sortSelectionHour();
        assertEquals(andrea, worker[0]);
        assertEquals(max,    worker[1]);
        assertEquals(susi,   worker[2]);
        assertEquals(werner, worker[3]);
        assertEquals(4, c.getNumber());
    }
}