public class Company
{
    private Worker[] worker;
    private int      number;

    public Company()
    {
        worker = new Worker[4];
        number = 0;
    }

    public Worker[] getWorker()
    {
        return worker;
    }

    public int getNumber()
    {
        return number;
    }

    public void setNumber(int number)
    {
        this.number = number;
    }

    public void hire(Worker newWorker)
    {
        if (newWorker != null)
        {
            if (number < worker.length)
            {
                worker[number] = newWorker;
                number++;
            }
            else
            {
                System.out.println("Error: no space left!");
            }
        }
        else
        {
            System.out.println("Error: not a worker!");
        }
    }

    public int numberWorkerMore20()
    {
        int res;

        res = 0;
        for (int i=0; i<number; i++)
        {
            if ((worker[i] != null) && (worker[i].getHour() >= 20))
            {
                res++;
            }
        }
        return res;
    }

    public int find(Worker w)
    {
        if (w != null)
        {
            for (int i = 0; i < number; i++)
            {
                if (worker[i] == w)
                    return i;
            }
            System.out.println("Error: could not find the worker!");
            return -1;
        }
        else
        {
            System.out.println("Error: not a worker!");
            return -1;
        }
    }

    public void remove(Worker w)
    {
        int pos;

        if (w != null)
        {
            pos = find(w);
            if (pos >= 0)
            {
                for (int i=pos+1; i<number; i++)
                {
                    worker[i-1]=worker[i];
                }
                worker[number-1] = null;
                number--;
            }
            else
            {
                System.out.println("Error: worker not in this company!");
            }
        }
        else
        {
            System.out.println("Error: not a worker!");
        }
    }

    public Worker maxEarn()
    {
        double max;
        Worker maxEarner;

        max = -999;
        maxEarner = null;
        for (int i=0; i<number; i++)
        {
            if (worker[i] != null)
            {
                if (worker[i].getHour()*worker[i].getPaymentHour() > max)
                {
                    max = worker[i].getHour()*worker[i].getPaymentHour();
                    maxEarner = worker[i];
                }
            }
        }
        return maxEarner;
    }

    public String toString()
    {
        String res;

        res = "";
        for (int i=0; i<number; i++)
        {
            res = res + worker[i].toString() + "\n";
        }
        return res;
    }
}
