import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class SchoolTest
{
    @Test
    public void testConstructor()
    {
        School s;
        s = new School();
        assertEquals(5, 5);
    }

    @Test
    public void aufnehmen()
    {
        School s;
        Student max, susi, werner, karl, andrea;
        Student []sessel;

        s = new School();
        max    = new Student("Max",    29, true);
        susi   = new Student("Susi",   22, true);
        werner = new Student("Werner", 17, false);
        karl   = new Student("Karl",   19, false);
        andrea = new Student("Andrea", 33, true);
        sessel = s.getSessel();
        assertEquals(null, sessel[0]);
        assertEquals(null, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(0, s.getAnzahl());

        s.aufnehmen(null);  //Fehler kein Student
        sessel = s.getSessel();
        assertEquals(null, sessel[0]);
        assertEquals(null, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(0, s.getAnzahl());

        s.aufnehmen(max);
        sessel = s.getSessel();
        assertEquals(max, sessel[0]);
        assertEquals(null, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(1, s.getAnzahl());

        s.aufnehmen(susi);
        sessel = s.getSessel();
        assertEquals(max, sessel[0]);
        assertEquals(susi, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(2, s.getAnzahl());

        s.aufnehmen(werner);
        sessel = s.getSessel();
        assertEquals(max, sessel[0]);
        assertEquals(susi, sessel[1]);
        assertEquals(werner, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(3, s.getAnzahl());

        s.aufnehmen(karl);
        sessel = s.getSessel();
        assertEquals(max, sessel[0]);
        assertEquals(susi, sessel[1]);
        assertEquals(werner, sessel[2]);
        assertEquals(karl, sessel[3]);
        assertEquals(4, s.getAnzahl());

        s.aufnehmen(andrea);    //Fehler kein Platz
        sessel = s.getSessel();
        assertEquals(max, sessel[0]);
        assertEquals(susi, sessel[1]);
        assertEquals(werner, sessel[2]);
        assertEquals(karl, sessel[3]);
        assertEquals(4, s.getAnzahl());
    }

    @Test
    public void testAvgAlter()
    {
        School s;
        Student max, susi, werner, karl;

        s = new School();
        max    = new Student("Max",    29, true);
        susi   = new Student("Susi",   22, true);
        werner = new Student("Werner", 17, false);
        karl   = new Student("Karl",   19, false);

        assertEquals(-999, s.avgAlter(), 0.1);

        s.aufnehmen(max);
        assertEquals(29, s.avgAlter(), 0.1);

        s.aufnehmen(susi);
        assertEquals(25.5, s.avgAlter(), 0.1);

        s.aufnehmen(werner);
        assertEquals(22.666666, s.avgAlter(), 0.1);

        s.aufnehmen(karl);
        assertEquals(21.75, s.avgAlter(), 0.1);
    }

    @Test
    public void testMaxAlter()
    {
        School s;
        Student max, susi, werner, karl;

        s = new School();
        max    = new Student("Max",    25, true);
        susi   = new Student("Susi",   22, true);
        werner = new Student("Werner", 29, true);
        karl   = new Student("Karl",   19, false);

        assertEquals(null, s.maxAlter());

        s.aufnehmen(max);
        assertEquals(max, s.maxAlter());

        s.aufnehmen(susi);
        assertEquals(max, s.maxAlter());

        s.aufnehmen(werner);
        assertEquals(werner, s.maxAlter());

        s.aufnehmen(karl);
        assertEquals(werner, s.maxAlter());
    }

    @Test
    public void testEinfugen()
    {
        School s;
        Student max, susi, werner, karl, andrea;
        Student []sessel;

        s = new School();
        max    = new Student("Max",    29, true);
        susi   = new Student("Susi",   22, true);
        werner = new Student("Werner", 17, false);
        karl   = new Student("Karl",   19, false);
        andrea = new Student("Andrea", 33, true);
        sessel = s.getSessel();

        assertEquals(null, sessel[0]);
        assertEquals(null, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(0, s.getAnzahl());

        s.einfugen(-1, max);                //Fehler
        assertEquals(null, sessel[0]);
        assertEquals(null, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(0, s.getAnzahl());

        s.einfugen(1, max);                //Fehler
        assertEquals(null, sessel[0]);
        assertEquals(null, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(0, s.getAnzahl());

        s.einfugen(0, max);
        assertEquals(max, sessel[0]);
        assertEquals(null, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(1, s.getAnzahl());

        s.einfugen(0, susi);
        assertEquals(susi, sessel[0]);
        assertEquals(max, sessel[1]);
        assertEquals(null, sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(2, s.getAnzahl());

        s.einfugen(1, werner);
        assertEquals(susi,   sessel[0]);
        assertEquals(werner, sessel[1]);
        assertEquals(max,    sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(3, s.getAnzahl());

        s.einfugen(1, null);                //Fehler
        assertEquals(susi,   sessel[0]);
        assertEquals(werner, sessel[1]);
        assertEquals(max,    sessel[2]);
        assertEquals(null, sessel[3]);
        assertEquals(3, s.getAnzahl());

        s.einfugen(0, karl);
        assertEquals(karl,   sessel[0]);
        assertEquals(susi,   sessel[1]);
        assertEquals(werner, sessel[2]);
        assertEquals(max,    sessel[3]);
        assertEquals(4, s.getAnzahl());

        s.einfugen(0, andrea);              //Fehler
        assertEquals(karl,   sessel[0]);
        assertEquals(susi,   sessel[1]);
        assertEquals(werner, sessel[2]);
        assertEquals(max,    sessel[3]);
        assertEquals(4, s.getAnzahl());
    }
}