import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class CompanyTest
{
    @Test
    public void testHire2()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 25, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        c.hire(max);
        c.hire(susi);
        System.out.println(c);
        worker = c.getWorker();
        assertEquals(max, worker[0]);
        assertEquals(susi, worker[1]);
        assertEquals(null, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(2, c.getNumber());
    }

    @Test
    public void testHireMax2()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 25, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        c.hire(max);
        c.hire(susi);
        c.hire(max);
        System.out.println(c);
        worker = c.getWorker();
        assertEquals(max, worker[0]);
        assertEquals(susi, worker[1]);
        assertEquals(max, worker[2]);
        assertEquals(null, worker[3]);
        assertEquals(3, c.getNumber());
    }


    @Test
    public void testHire5()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 25, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        c.hire(max);
        c.hire(susi);
        c.hire(andrea);
        c.hire(werner);
        c.hire(karl);                       // Error
        System.out.println(c);
        worker = c.getWorker();
        assertEquals(max, worker[0]);
        assertEquals(susi, worker[1]);
        assertEquals(andrea, worker[2]);
        assertEquals(werner, worker[3]);
        assertEquals(4, c.getNumber());
    }

    @Test
    public void testNumberWorkerMore20()
    {
        Company c;
        Worker max, susi, andrea, werner, karl;
        Worker[] worker;

        c = new Company();
        max    = new Worker("Max",    20, 45);
        susi   = new Worker("Susi",   30, 55);
        andrea = new Worker("Andrea", 18, 40);
        werner = new Worker("Werner", 15, 47);
        karl   = new Worker("Karl",   35, 59);
        assertEquals(0, c.numberWorkerMore20());
        c.hire(max);
        assertEquals(1, c.numberWorkerMore20());
        c.hire(susi);
        assertEquals(2, c.numberWorkerMore20());
        c.hire(andrea);
        assertEquals(2, c.numberWorkerMore20());
        c.hire(werner);
        assertEquals(2, c.numberWorkerMore20());
    }
}