public class Temperature
{
    private String   city;
    private double[] temp;
    private int      numberDays;

    public Temperature(String city)
    {
        setCity (city);
        temp = new double[13];
        setNumberDays (0);
    }

    public void testdata()
    {
        temp[0] = 7.2;
        temp[1] = 8.5;
        temp[2] = 9.7;
        temp[3] = 6.2;
        temp[4] = 4.1;
        temp[5] = 0;
        temp[6] = 2.5;
        temp[7] = 3.7;
        temp[8] = 8.9;
        temp[9] = 6.7;
        numberDays = 10;
    }

    public void testdata2()
    {
        temp[0] = 7.2;
        temp[1] = 8.5;
        temp[2] = 9.7;
        temp[3] = 6.2;
        temp[4] = 4.1;
        temp[5] = 0;
        temp[6] = 2.5;
        temp[7] = 3.7;
        temp[8] = 8.9;
        temp[9] = 12.4;
        numberDays = 10;
    }

    public void testdata3()
    {
        temp[0] = 7.2;
        temp[1] = 8.5;
        temp[2] = 9.7;
        temp[3] = 6.2;
        temp[4] = 11.1;
        temp[5] = 0;
        temp[6] = 2.5;
        temp[7] = 3.7;
        temp[8] = 8.9;
        temp[9] = 5.4;
        numberDays = 10;
    }

    public void testdata4()
    {
        temp[0] = 7.2;
        temp[1] = 8.5;
        temp[2] = 9.7;
        temp[3] = 6.2;
        temp[4] = 11.1;
        temp[5] = 0;
        temp[6] = 2.5;
        temp[7] = 3.7;
        temp[8] = 8.9;
        temp[9] = 5.4;
        temp[10] = 5.4;
        temp[11] = 5.4;
        temp[12] = 5.4;
        numberDays = 13;
    }

    public double[] getTemp()
    {
        return temp;
    }

    public void setTemp(double[] temp)
    {
        this.temp = temp;
    }

    public int getNumberDays()
    {
        return numberDays;
    }

    public void setNumberDays(int numberDays)
    {
        if ((numberDays >= 0) && (numberDays <= temp.length))
            this.numberDays = numberDays;
        else
        {
            System.out.println("Error: wrong number of days!");
            this.numberDays = 0;
        }
    }

    public String getCity()
    {
        return city;
    }

    public void setCity(String city)
    {
        this.city = city;
    }

    public double maxTemperature()
    {
        double max;

        max = -999;
        for (int i=0; i<numberDays; i++)
        {
            if (temp[i] > max)
            {
                max = temp[i];
            }
        }
        return max;
    }

    public double maxTemperatureIncrease()
    {
        double max;

        max = -999;
        for (int i=0; i<numberDays-1; i++)
        {
            if ((temp[i+1]>temp[i]) && ((temp[i+1]-temp[i]) > max))
            {
                max = temp[i+1]-temp[i];
            }
        }
        return max;
    }

    public void insert(double value, int pos)
    {
        if ((pos>=0) && (pos < numberDays))
        {
            if (numberDays < temp.length)
            {
                for (int i = numberDays - 1; i >= pos; i--)
                {
                    temp[i + 1] = temp[i];
                }
                temp[pos] = value;
                numberDays++;
            }
            else
            {
                System.out.println("Error no space left!");
            }
        }
        else
        {
            System.out.println("Error wrong position!");
        }
    }

    public int numberOfHigh()
    {
        int max;

        max = 0;
        for (int i=1; i<numberDays-1; i++)
        {
            if ((temp[i] > temp[i-1]) && (temp[i] > temp[i+1]))
            {
                max++;
            }
        }
        return max;
    }

    public String toString()
    {
        String result;

        result = "";
        for (int i=0; i<numberDays; i++)
        {
            result = result + "Temperture at day " + i + ": " + temp[i] + "\n";
        }
        return result;
    }
}
