

import static org.junit.jupiter.api.Assertions.*;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHaus
{
    @Test
    public void testEinbauen()
    {
        Fenster a, b, c, d;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       399, false);
        d = new Fenster("Kunststoff", 199, false);
        haus = new Haus("Wiener Neustadt");
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(a);
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(b);
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(c);
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(d);
        // Fehler
        haus.printHaus();
        System.out.println("====================");
    }
    
    @Test
    public void testMaxPreis0()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        669, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       399, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(-9999, haus.teuerstesFenster());
        haus.einbauen(a);
        assertEquals(669, haus.teuerstesFenster());
        haus.einbauen(b);
        assertEquals(669, haus.teuerstesFenster());
        haus.einbauen(c);
        assertEquals(669, haus.teuerstesFenster());
        haus.printHaus();
    }
    
    @Test
    public void testMaxPreis1()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       399, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(-9999, haus.teuerstesFenster());
        haus.einbauen(a);
        assertEquals(499, haus.teuerstesFenster());
        haus.einbauen(b);
        assertEquals(599, haus.teuerstesFenster());
        haus.einbauen(c);
        assertEquals(599, haus.teuerstesFenster());
        haus.printHaus();
    }

    @Test
    public void testMaxPreis2()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       649, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(-9999, haus.teuerstesFenster());
        haus.einbauen(a);
        assertEquals(499, haus.teuerstesFenster());
        haus.einbauen(b);
        assertEquals(599, haus.teuerstesFenster());
        haus.einbauen(c);
        assertEquals(649, haus.teuerstesFenster());
        haus.printHaus();
    }

    @Test
    public void testMinPreisOhne()
    {
        Haus haus;
        
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
    }
    
    @Test
    public void testMinPreis0()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       649, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
        haus.einbauen(a);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(b);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(c);
        assertEquals(a, haus.billigFenster());
    }
    
    @Test
    public void testMinPreis1()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       399, true);
        c = new Fenster("Holz",       649, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
        haus.einbauen(a);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(b);
        assertEquals(b, haus.billigFenster());
        haus.einbauen(c);
        assertEquals(b, haus.billigFenster());
    }    

    @Test
    public void testMinPreis2()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       349, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
        haus.einbauen(a);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(b);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(c);
        assertEquals(c, haus.billigFenster());
    }    
}

