CREATE OR REPLACE PROCEDURE PROC_GRIESMAYER_SALES_STAGING IS
    V_TABCNT NUMBER;
BEGIN
    SELECT count(*)
    INTO   V_TABCNT
    FROM   ALL_TABLES
    WHERE  OWNER = 'GRIESMAYER' AND
           TABLE_NAME = 'GRIESMAYER_SALES_STAGING';
    
    IF V_TABCNT = 0 THEN
        EXECUTE IMMEDIATE 'CREATE TABLE GRIESMAYER_SALES_STAGING
                           (
                               SALES_DATE          DATE          NOT NULL,
                               SALES_TIME          INTEGER       NOT NULL,
                               SALES_CHANNEL       INTEGER       NOT NULL,
                               PRODUCT_ID          INTEGER       NOT NULL,
                               CUSTOMER_ID         INTEGER       NOT NULL,
                               PIECES              INTEGER       NOT NULL,
                               REVENUE             DECIMAL(12,2) NOT NULL,
                               DISCOUNT            DECIMAL(12,2) NOT NULL,
                               TAX                 DECIMAL(12,2) NOT NULL
                           )';
    END IF;

END;
