#!/bin/bash


for FILE in `ls /oracle_data/data`
do
        export FILE_ONLY=`echo $FILE | sed -e 's/\..*//'`
        echo $FILE $FILE_ONLY
        sqlldr griesmayer/oracle@//localhost/XEPDB1 data=/oracle_data/data/$FILE_ONLY.csv control=/oracle_data/src/sales.ldr log=~/$FILE_ONLY.log bad=~/$FILE_ONLY.bad errors=5

        export ACT_TEMP=`curl --user-agent "Mozilla/4.0" https://wetter.orf.at/oes/ | grep "temperature" | head -n 1 | sed -e 's/^[^>]*>//' | sed -e 's/&.*//' | sed -e 's/,/./'`

        sqlplus griesmayer/oracle@//localhost/XEPDB1 <<!
INSERT INTO SALES
SELECT sal.*,
       $ACT_TEMP
FROM   SALES_STAGING sal;
exit;
!

done

